/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.api.wsrr;

import filenet.ws.api.wsrr.commonj.sdo.ChangeSummarySetting;
import filenet.ws.api.wsrr.commonj.sdo.DataGraphType;
import filenet.ws.api.wsrr.commonj.sdo.ObjectChangeValueType;
import filenet.ws.api.wsrr.serviceregistry_6_0.sdo.BaseObject;
import filenet.ws.api.wsrr.serviceregistry_6_0.sdo.ComplexTypeDefinition;
import filenet.ws.api.wsrr.serviceregistry_6_0.sdo.Document;
import filenet.ws.api.wsrr.serviceregistry_6_0.sdo.Export;
import filenet.ws.api.wsrr.serviceregistry_6_0.sdo.Module;
import filenet.ws.api.wsrr.serviceregistry_6_0.sdo.PropertyQuery;
import filenet.ws.api.wsrr.serviceregistry_6_0.sdo.UserDefinedProperty;
import filenet.ws.api.wsrr.serviceregistry_6_0.sdo.WSDLBinding;
import filenet.ws.api.wsrr.serviceregistry_6_0.sdo.WSDLMessage;
import filenet.ws.api.wsrr.serviceregistry_6_0.sdo.WSDLPort;
import filenet.ws.api.wsrr.serviceregistry_6_0.sdo.WSDLPortType;
import filenet.ws.api.wsrr.serviceregistry_6_0.sdo.WSDLService;
import filenet.ws.api.wsrr.serviceregistry_6_0.sdo.WSRR;
import filenet.ws.api.wsrr.serviceregistry_6_0.sdo._import;
import filenet.ws.api.wsrr.serviceregistry_6_0.ws.sdo.ServiceRegistryWebServiceException;
import filenet.ws.api.wsrr.serviceregistry_6_0.ws.sdo.WSRRCoreSDOPortType;
import java.util.HashMap;

public class WSWSRRUtilities {
    static DataGraphType createDataGraph(BaseObject[] objects, String rootID) {
        WSRR wsrr = new WSRR();
        wsrr.setArtefacts(objects);
        wsrr.setRoot(rootID);
        DataGraphType dg = new DataGraphType();
        dg.setWSRR(wsrr);
        return dg;
    }

    static HashMap buildHashMap(DataGraphType dg) {
        HashMap hm = new HashMap();
        BaseObject[] topLevelObjects = dg.getWSRR().getArtefacts();
        WSWSRRUtilities.mapArrayOfBaseObjects(hm, topLevelObjects);
        return hm;
    }

    private static void mapArrayOfBaseObjects(HashMap hm, BaseObject[] baseObjects) {
        for (BaseObject baseObject : baseObjects) {
            WSWSRRUtilities.mapBaseObject(hm, baseObject);
        }
    }

    private static void mapBaseObject(HashMap hm, BaseObject baseObject) {
        String bsrURI = baseObject.getBsrURI().toString();
        if (hm.get(bsrURI) == null) {
            hm.put(bsrURI, baseObject);
        }
        if (baseObject instanceof ComplexTypeDefinition) {
            ComplexTypeDefinition ctd = (ComplexTypeDefinition)baseObject;
            WSWSRRUtilities.mapArrayOfBaseObjects(hm, ctd.getLocalAttributes());
        } else if (baseObject instanceof Export) {
            Export exp = (Export)baseObject;
            WSWSRRUtilities.mapBaseObject(hm, exp.getExportBinding());
            WSWSRRUtilities.mapArrayOfBaseObjects(hm, exp.getInterfaces());
        } else if (baseObject instanceof _import) {
            _import imp = (_import)baseObject;
            WSWSRRUtilities.mapBaseObject(hm, imp.getImportBinding());
            WSWSRRUtilities.mapArrayOfBaseObjects(hm, imp.getInterfaces());
        } else if (baseObject instanceof Module) {
            Module module = (Module)baseObject;
            WSWSRRUtilities.mapArrayOfBaseObjects(hm, module.getImports());
            WSWSRRUtilities.mapArrayOfBaseObjects(hm, module.getExports());
        } else if (baseObject instanceof WSDLBinding) {
            WSWSRRUtilities.mapBaseObject(hm, ((WSDLBinding)baseObject).getSOAPBinding());
        } else if (baseObject instanceof WSDLMessage) {
            WSWSRRUtilities.mapArrayOfBaseObjects(hm, ((WSDLMessage)baseObject).getMessageParts());
        } else if (baseObject instanceof WSDLPort) {
            WSWSRRUtilities.mapBaseObject(hm, ((WSDLPort)baseObject).getSOAPAddress());
        } else if (baseObject instanceof WSDLPortType) {
            WSWSRRUtilities.mapArrayOfBaseObjects(hm, ((WSDLPortType)baseObject).getOperations());
        } else if (baseObject instanceof WSDLService) {
            WSWSRRUtilities.mapArrayOfBaseObjects(hm, ((WSDLService)baseObject).getPorts());
        }
    }

    static void declareRootDocumentContentChanged(DataGraphType dg) {
        if (dg != null) {
            Document doc = (Document)WSWSRRUtilities.getRootObject(dg);
            if (doc != null) {
                ObjectChangeValueType[][] changeSummary = new ObjectChangeValueType[1][];
                ObjectChangeValueType[] objectChangeValueTypes = new ObjectChangeValueType[2];
                ChangeSummarySetting changeSummarySetting = new ChangeSummarySetting();
                changeSummarySetting.setDataValue(doc.getContent());
                changeSummarySetting.setFeatureName("content");
                objectChangeValueTypes[0] = changeSummarySetting;
                changeSummarySetting = new ChangeSummarySetting();
                changeSummarySetting.setDataValue(doc.getDescription().getBytes());
                changeSummarySetting.setFeatureName("description");
                objectChangeValueTypes[1] = changeSummarySetting;
                changeSummary[0] = objectChangeValueTypes;
                dg.setChangeSummary(changeSummary);
            } else {
                System.err.println("null doc");
            }
        } else {
            System.err.println("null dg");
        }
    }

    static void declareRootDocumentVersionChanged(DataGraphType dg) {
        if (dg != null) {
            Document doc = (Document)WSWSRRUtilities.getRootObject(dg);
            if (doc != null) {
                ObjectChangeValueType[][] changeSummary = new ObjectChangeValueType[1][];
                ChangeSummarySetting changeSummarySetting = new ChangeSummarySetting();
                changeSummarySetting.setDataValue(doc.getContent());
                changeSummarySetting.setFeatureName("version");
                ObjectChangeValueType[] objectChangeValueTypes = new ObjectChangeValueType[]{changeSummarySetting};
                changeSummary[0] = objectChangeValueTypes;
                dg.setChangeSummary(changeSummary);
            } else {
                System.err.println("null doc");
            }
        } else {
            System.err.println("null dg");
        }
    }

    static void printQueryResult(DataGraphType[] resultArray) {
        if (resultArray != null) {
            System.out.println("Number of results: " + resultArray.length);
            for (int i = 0; i < resultArray.length; ++i) {
                DataGraphType dg = resultArray[i];
                if (dg != null) {
                    WSWSRRUtilities.printRootObject(dg);
                    continue;
                }
                System.err.println("Null dg");
            }
        } else {
            System.err.println("Null resultArray");
        }
    }

    static void printRootObject(DataGraphType dg) {
        BaseObject baseObject = WSWSRRUtilities.getRootObject(dg);
        if (baseObject != null) {
            System.out.println();
            System.out.println(baseObject.getBsrURI());
            System.out.print("{");
            System.out.print(baseObject.getName());
            System.out.print(", ");
            System.out.print(baseObject.getNamespace());
            System.out.print(", ");
            System.out.print(baseObject.getVersion());
            System.out.println("}");
            if (baseObject instanceof Document) {
                System.out.println("content:");
                Document doc = (Document)baseObject;
                String documentContent = new String(doc.getContent());
                System.out.println(documentContent);
            }
        } else {
            System.err.println("Root object not found");
        }
    }

    static BaseObject getRootObject(DataGraphType dg) {
        BaseObject baseObject = null;
        WSRR wsrr = dg.getWSRR();
        if (wsrr != null) {
            String rootObjectID = wsrr.getRoot().toString();
            if (rootObjectID != null) {
                if (!rootObjectID.equals("")) {
                    HashMap hm = WSWSRRUtilities.buildHashMap(dg);
                    if (hm != null) {
                        baseObject = (BaseObject)hm.get(rootObjectID);
                    } else {
                        System.err.println("Root object not in HashMap");
                    }
                } else {
                    System.err.println("empty rootObjectID");
                }
            } else {
                System.err.println("null rootObjectID");
            }
        } else {
            System.err.println("null wsrr");
        }
        return baseObject;
    }

    static String[] queryMatchingURIs(WSRRCoreSDOPortType wsrrCoreSDOPortType, String queryExpression) {
        String[] results = null;
        PropertyQuery pq = new PropertyQuery();
        pq.setBsrURI("_1");
        pq.setQueryExpression(queryExpression);
        UserDefinedProperty udp = new UserDefinedProperty();
        UserDefinedProperty[] udps = new UserDefinedProperty[]{udp};
        udp.setName("TheNameIsUnimportant");
        udp.setValue("bsrURI");
        pq.setUserDefinedProperties(udps);
        BaseObject[] artefactArray = new BaseObject[]{pq};
        DataGraphType dg = WSWSRRUtilities.createDataGraph(artefactArray, pq.getBsrURI().toString());
        try {
            DataGraphType[] resultDGs = wsrrCoreSDOPortType.executeQuery(dg);
            if (resultDGs != null) {
                if (resultDGs.length > 0) {
                    results = new String[resultDGs.length];
                    for (int i = 0; i < resultDGs.length; ++i) {
                        DataGraphType resultDG = resultDGs[i];
                        if (resultDG != null) {
                            UserDefinedProperty[] resultUDPs = resultDG.getPropertyQueryResult();
                            if (resultUDPs != null) {
                                UserDefinedProperty resultUDP = resultUDPs[0];
                                results[i] = resultUDP.getValue();
                                continue;
                            }
                            System.err.println("Got null UserDefinedProperties");
                            continue;
                        }
                        System.err.println("null resultDG");
                    }
                } else {
                    System.err.println("Was expecting at least one DG");
                }
            } else {
                System.err.println("null resultDGs");
            }
        }
        catch (ServiceRegistryWebServiceException srwse) {
            System.err.println("Caught ServiceRegistryWebServiceException");
            System.err.println(srwse.getMessage());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return results;
    }

    public static String _get_FILE_DATE() {
        return "$Date:   10 Sep 2008 10:04:06  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ysoong  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.1  $";
    }
}

